#include "Utilities/Configuration/interface/Architecture.h"

#include "Tracker/CARFTracker/interface/EventAnalyser.h"
#include "Utilities/Notification/interface/Observer.h"

#include "TrackerReco/ClusterShaper/interface/ProcessTracker.h"

#include "TROOT.h"
#include "TFile.h"
#include "TNtuple.h"

#include "TStopwatch.h"

TNtuple *ntuple;

extern geom_t geom;

///////////////////////////////////////////////////////////////////////////////
class MyEventAnalyser : public Observer< TkSimEvent*> {
 public:
   MyEventAnalyser();
   ~MyEventAnalyser();
   virtual void upDate  (TkSimEvent* ev) {if (ev!=0) analysis(ev);}
   virtual void analysis(TkSimEvent* ev);

 private:
   TFile *outfile;
};

///////////////////////////////////////////////////////////////////////////////
MyEventAnalyser::MyEventAnalyser()
{
 init();

 outfile = new TFile("out/result.root","RECREATE");
 outfile->cd();
 ntuple = new TNtuple("result","result",
   "z:r:lay:ncha:minsize:she:phi:qk:z0:dEdx:chi2:dmax:s_she:s_phi:s_qk:s_z0:type:barrel:pixel:rot:indep:event:vertexz:sizex:sizey");

}

///////////////////////////////////////////////////////////////////////////////
MyEventAnalyser::~MyEventAnalyser()
{
 outfile->cd();
 ntuple->Write("result");
 outfile->Write();
 outfile->Close();
}

///////////////////////////////////////////////////////////////////////////////
void MyEventAnalyser::analysis(TkSimEvent* simEvent)
{
  const G3EventProxy* ev = simEvent->G3eventProxy();

  int thisEvent = ev->simSignal()->id().eventInRun();
  int thisRun   = ev->simSignal()->id().runNumber();

  geom.vertexz = ev->simSignal()->vertex(0).position().z();
  geom.event = thisEvent;

  cerr << "#################################################" << endl;
  cerr << "Run " << thisRun << "  Event " << thisEvent << endl;

  TStopwatch timer;
  timer.Start();

  ProcessTracker theProcessTracker;
  theProcessTracker.doAll();

  timer.Stop();
  cerr << "  [ClusterShaper] timer = (" 
       << timer.CpuTime()     << " s)" 
       << endl;
}

///////////////////////////////////////////////////////////////////////////////
#include "Utilities/Notification/interface/PackageInitializer.h"

PKBuilder<MyEventAnalyser> eventAnalyser("MyEventAnalyser");

