#include "Utilities/Configuration/interface/Architecture.h"

#include "TrackerReco/ClusterShaper/interface/TridiagonalMatrix.h"

#include <cmath>
#include <vector>

double Coupling = 0.12;

/******************************************************************************/
void TridiagonalMatrix::solve
  (double a[], double b[], double c[], double r[], double u[], int n)

/* Solves for a vector u[1..n] the tridiagonal linear set given by 
equation (2.4.1). a[1..n], b[1..n], c[1..n], and r[1..n] are input vectors 
and are not modified. */

{
 int j;
 double bet;
 vector<double> gam(n); // One vector of workspace, gam is needed.

 u[0]=r[0]/(bet=b[0]);

 for (j=1;j<n;j++)
 { // Decomposition and forward substitution.
   gam[j]=c[j-1]/bet;
   bet=b[j]-a[j]*gam[j];
   if (bet == 0.0) { fprintf(stderr," [tridiag] fail\n"); exit(1); }
   u[j]=(r[j]-a[j]*u[j-1])/bet; 
 }

 for (j=n-2;j>=0;j--)
   u[j] -= gam[j+1]*u[j+1]; // Backsubstitution.
}

/******************************************************************************/
void TridiagonalMatrix::decoupleStrips
  (int n, double measured[], double decoupled[])
{
 int i;
 vector<double> a(n),b(n),c(n);

 b[0] = 1; b[n-1] = 1;
 a[1] = 0; c[n-2] = 0;

 for(i=1; i<n-1; i++) b[i] = 1-2*Coupling;
 for(i=2; i<n  ; i++) a[i] =     Coupling;
 for(i=0; i<n-2; i++) c[i] =     Coupling;

 fprintf(stderr,"%.2f %.2f %.2f %.2f\n",b[0],c[0],0.  ,0.);
 fprintf(stderr,"%.2f %.2f %.2f %.2f\n",a[1],b[1],c[1],0.);
 fprintf(stderr,"%.2f %.2f %.2f %.2f\n",0.  ,a[2],b[2],c[2]);
 fprintf(stderr,"%.2f %.2f %.2f %.2f\n",0.  ,0.  ,a[3],b[3]);

 solve(&a[0],&b[0],&c[0], measured,decoupled, n);
}
