#include "Utilities/Configuration/interface/Architecture.h"

#include "TrackerReco/ClusterShaper/interface/FitClusterPosition.h"

#include <cstdlib>
#include <vector>

/*****************************************************************************/
FitClusterPosition::FitClusterPosition() {}

/*****************************************************************************/
FitClusterPosition::~FitClusterPosition() {}

/*****************************************************************************/
void FitClusterPosition::findContainer
  (int ncha,int pos[][3], int *minsize,int *indep,double ends[2], int size[2])
{
 int extremum[2][2];
 for(int i=0; i<ncha; i++)
  for(int k=0; k<2; k++)
  {
   if(pos[i][k] < extremum[k][0] || i==0) extremum[k][0] = pos[i][k];
   if(pos[i][k] > extremum[k][1] || i==0) extremum[k][1] = pos[i][k];
  }

 for(int k=0; k<2; k++)
  size[k] = abs(extremum[k][1] - extremum[k][0]);

 *minsize = (size[0] < size[1] ? size[0] : size[1]);

 if(size[0] >= size[1]) *indep = 0;
                   else *indep = 1;

 for(int k=0; k<2; k++)
  ends[k] = extremum[*indep][k] + 0.5 + (2*k-1) * 0.15;
}

/*****************************************************************************/
void FitClusterPosition::fitStraightLine
  (int n, double *x,double *y,double *w, double par[])
{
 double s=0., sx=0., sy=0., sxx=0., sxy=0.;

 for(int i=0; i<n; i++)
 {
  s   += w[i];
  sx  += x[i] * w[i];
  sy  += y[i] * w[i];

  sxx += x[i]*x[i] * w[i];
  sxy += x[i]*y[i] * w[i];
 } 

 double D = s*sxx - sx*sx;

 par[0] = (sxx*sy - sx*sxy)/D;
 par[1] = (sxy*s  - sx*sy )/D;
}

/*****************************************************************************/
void FitClusterPosition::fit
  (int ncha, int val[][3], double endpoint[2][2], int *minsize, int *indep, int size[2])
{
 if(ncha >= 2)
 {
  // Choose independent variable
  double ends[2];
  findContainer(ncha,val, minsize, indep,ends, size);

  // Allocate
  vector<double> x(ncha), y(ncha), w(ncha);
 
  // Copy and fit line
  for(int i=0; i<ncha; i++)
  {
   x[i] = val[i][   *indep] + 0.5;
   y[i] = val[i][1- *indep] + 0.5;
   w[i] = val[i][2];
  }
 
  double par[2];
  fitStraightLine(ncha, &x[0],&y[0],&w[0], par);

  // Calculate endpoints
  for(int i=0; i<2; i++)
  {
   endpoint[i][   *indep] = ends[i];
   endpoint[i][1- *indep] = par[1]*ends[i] + par[0];
  }
 }
 else
 {
  // Simply copy
  for(int i=0; i<2; i++)
  for(int k=0; k<2; k++)
   endpoint[i][k] = val[0][k] + 0.5;
 }
}

