#include "Utilities/Configuration/interface/Architecture.h"

#include "TrackerReco/ClusterShaper/interface/EstimatePrimaryVertex.h"

#include "TrackerReco/ClusterShaper/interface/LevenbergMarquardt.h"

#include <iostream>

#include <cmath>

extern geom_t geom;

/*****************************************************************************/
EstimatePrimaryVertex::EstimatePrimaryVertex() { }

/*****************************************************************************/
EstimatePrimaryVertex::~EstimatePrimaryVertex() { }

/*****************************************************************************/
double EstimatePrimaryVertex::prob
 (double a, double x, double y)
{
 double e1,e2,e3;

 double s = 1.5;
 double secondaries = 1.;
 double background  = 1e-3;

 e1 = M_2_SQRTPI/2/M_SQRT2 * exp(-sqr((y    -a)/s)/2);
 e2 = M_2_SQRTPI/2/M_SQRT2 * exp(-sqr((y-2*x+a)/s)/2);
 e3 = secondaries *
      (erf((y    -a)/s/M_SQRT2)
      -erf((y-2*x+a)/s/M_SQRT2))/2/(2*(x-a));

 if(!finite(e1)) e1 = 0.;
 if(!finite(e2)) e2 = 0.;
 if(!finite(e3)) e3 = 0.;

 return(e1+e2+e3+background);
}

/*****************************************************************************/
double EstimatePrimaryVertex::function
 (double par[], double x, double y, int rank)
{
 double val=0., v[3],p[3];

 double a = par[0];

 v[0] = prob(a-1e-3,x,y);
 v[1] = prob(a     ,x,y);
 v[2] = prob(a+1e-3,x,y);

 /*
 for(double b=a-1.; b<=a+1.; b+=0.2)
	 fprintf(stderr," b=%f %f\n",b,prob(b,x,y));
	 */

 p[0] = v[1];
 p[1] = (v[2]-v[0])/(2*1e-3);
 p[2] = (v[2]+v[0]-2*v[1])/1e-3/1e-3;

 /*
 p1 = (y    -a)/sqr(s) * e1 -
      (y-2*x+a)/sqr(s) * e2;
 
 p2 = (sqr((y    -a)/sqr(s)) - 1/sqr(s)) * e1 +
      (sqr((y-2*x+a)/sqr(s)) - 1/sqr(s)) * e2;
 */
     
 // logf, dlogf/da
 if(rank == 0) val = -2 * log(p[0]);
 if(rank == 1) val =   p[1]/p[0];
 if(rank == 2) val = -(p[2]*p[0] - p[1]*p[1])/sqr(p[0]);

 if(!finite(val))
  fprintf(stderr," val = %e | %d\n",val,rank);

 return(val);
}

/*****************************************************************************/
void EstimatePrimaryVertex::getFunction(double par[], double *chi2)
{
 // Clear
 *chi2 = 0.;

 // Sum for all the touched channels
 for(int i=0; i<nclus; i++)
 {
  double val = function(par, zclus[i].z, zclus[i].z0, 0);
  *chi2 += val;
 }
}

/*****************************************************************************/
void EstimatePrimaryVertex::collectDerivatives
  (double par[], zclus_t *zclus, double sec[], double der[], double *val)
{
 sec[0] = function(par, zclus->z, zclus->z0, 2);
 der[0] = function(par, zclus->z, zclus->z0, 1);
 *val   = function(par, zclus->z, zclus->z0, 0);
}

/*****************************************************************************/
void EstimatePrimaryVertex::getDerivatives
  (double par[], double beta[],Matrix<double>* alpha)
{
 double val;
 vector<double> der(npar);
 double sec[1];

 // Clear
 for(int k=0; k<npar; k++)
 {
  beta[k] = 0.;
  for(int l=0; l<npar; l++) (*alpha)(k,l) = 0.;
 }

 // For all the clusters
 for(int i=0; i<nclus; i++)
 {
  // Get derivatives
  collectDerivatives(par,&zclus[i], &sec[0], &der[0],&val);

  // Fill beta and alpha (for cluster)
  // If sec<0, go to the direction of beta
  for(int k=0; k<npar; k++)
  {
   beta[k] += der[k];
   for(int l=0; l<npar; l++)
    (*alpha)(k,l) += sec[0];
  }
 }

// fprintf(stderr," --> %f %f\n",(*alpha)(0,0),beta[0]);

 if((*alpha)(0,0) < 0)
  (*alpha)(0,0) = fabs(beta[0]);
}

/*****************************************************************************/
void EstimatePrimaryVertex::fit(int ndata, vector<zvertex_t> data)
{
 // Allocate
 zclus.reserve(10);

 // Copy
 zclus_t d;
 nclus = ndata;
 for(int i=0; i<nclus; i++)
 {
  d.z  = data[i].z;
  d.z0 = data[i].z0;

  zclus.push_back(d);
 }

 npar = 1;

 cerr << "  [ClusterShaper] EstimatPrimaryVertex [" << nclus << "]" << endl;

 /*
 FILE *file;
 file = fopen("a.dat","w");
 for(double a=-20.; a<20; a+=0.01)
 {
  double chi2;
  getFunction(&a,&chi2);
  fprintf(file,"%f %e\n",a,chi2);
 }
 fclose(file);
 */

 LevenbergMarquardt<EstimatePrimaryVertex> theLevenbergMarquardt;
 vector<double> par(npar),err(npar);
 int nstep;

 par[0] = 0.; // par[1] = 1.5; par[2] = 1.; par[3] = 1e-3;
 theLevenbergMarquardt.minimize(this, npar, &par[0],&err[0], &nstep);

 fprintf(stderr,"  [ClusterShaper]  z0 = %.3f cm (%c %.3f cm)  [%d steps]\n",
		 par[0],177,err[0], nstep);
 fprintf(stderr,"  [ClusterShaper]  z0 = %.3f cm (simulated)\n",geom.vertexz);
 fprintf(stderr," sr %f %f %d\n",geom.vertexz,par[0],nclus);

// while(getchar()==0);
}

