#ifndef _HEADER_H_
#define _HEADER_H_

// Debian
/*
#define gnu_major(dev)        major(dev)
#define gnu_minor(dev)        minor(dev)
#define gnu_makedev(maj, min) makedev(maj, min)
*/

#define Npar 5
#define Spar 3

#include "Utilities/UI/interface/SimpleConfigurable.h"

inline bool debug()
{ return SimpleConfigurable<bool>(false, "ClusterShaper:debug").value(); }

inline bool active()
{ return SimpleConfigurable<bool>(true, "ClusterShaper:active").value(); }

inline bool processPixels()
{ return SimpleConfigurable<bool>(false, "ClusterShaper:pixels").value(); }

inline bool processStrips()
{ return SimpleConfigurable<bool>(false, "ClusterShaper:strips").value(); }

inline double sqr (double x) { return x*x; }
inline double sign(double x) { return (x>0 ? 1 : -1); }

typedef struct {
	 double z,z0;
} zvertex_t;

typedef struct {
 int position[2],adc;
} channel_t;

typedef struct {
 int position[2],adc, endpoint, nc,sign;
 double length, normal[4][2], dx[4][2];
} pixel_t;

typedef struct {
 double pos[3], rot[3][3], pitch[3], thickness, shift[2], center[2];
 int flipped, dimension[2], mode, barrel,pixel, event;
 double vertexz;
} geom_t;

typedef struct {
 double pos[2];
 int edg, typ,rel;
} cross_t;

/*
class GeneralModel
{
 public:
   virtual void getFunction   
                  (double par[], double *chi2) = 0;
   virtual void getDerivatives
                  (double par[], double beta[],double alpha[][Npar]) = 0;
};
*/

#endif
