#ifndef _FIT_STRIP_CLUSTER_H_
#define _FIT_STRIP_CLUSTER_H_

#include "Header.h"

#include "TrackerReco/ClusterShaper/interface/Matrix.h"

#include <vector>

class Transformations;

class FitStripCluster
{
 public:  
   FitStripCluster();
   ~FitStripCluster();
   void getFunction(double cluster[], double *chi2);
   void getDerivatives
	     (double cluster[], double beta[],Matrix<double>* alpha);
   void fit
     (int ncha, int val[][3], double endpoint[], double track[][Npar+1]);

 private:
  double function(double z, int rank);
  int getPath(double point[], vector<pixel_t>* pixel);
  void negativeDistance(pixel_t *pixel, double endpoint[]);
  void fillAdc
	    (int nchannel,channel_t *channel,
             int *npixel ,vector<pixel_t>* pixel, double endpoint[]);
  void prepareStrips(double endpoint[]);
  void collectDerivativesCluster
	   (double par[],pixel_t *pixel, double length,
	     double der[], double *val);

  // Measured
  int nchannel;
  vector<channel_t> channel;

  // Calculated
  int npixel;
  vector<pixel_t> pixel;
};

#endif
